#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// breathing kaleidoscopeMod01.fsh  by   HaleyHalcyon
//https://www.shadertoy.com/view/stffW2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define TAU (6.283185307)
#define HEX(x) (vec3((x >> 16) & 255, (x >> 8) & 255, x & 255) / 255.)

vec3 color(float x){
    const int colorCount = 10;
    vec3[] c = vec3[](
        vec3(0),
        HEX(0x270051),
        HEX(0x3f0cd7),
        HEX(0x0889eb),
        HEX(0x41b1b0),
        HEX(0x89d97d),
        HEX(0xd6fd58),
        HEX(0xfef38f),
        HEX(0xfffce5),
        vec3(1)
    );
    x *= float(colorCount);
    int lo = int(floor(x));
    
    return mix(
        c[lo],
        c[(lo + 1) % colorCount],
        smoothstep(0.0, 1., fract(x))
    );
}

float zigzag(float x) {
    return 1. - (abs(1. - mod(x, 2.0)));
}

#define REP 10. // how many pairs of reflections do you want

// i am dumb and i can't think of a better way to do this than converting to polar coords and back
vec2 kaleido(vec2 uv, float tx_rot, float circ_rot) {
    float r = length(uv);
    float theta = atan(uv.y, uv.x);
    theta = zigzag(
        REP * 2. * (
            theta + circ_rot
        ) / TAU
    ) * TAU / (REP * 2.) + tx_rot;
    uv = r * vec2(
        cos(theta), sin(theta)
    );
    return uv;
}

float sway(float time) {
    return //smoothstep(0., 1.,
    mix(
        sin(TAU * (0.5 - time) * (0.5 - time)),
        sin(TAU * (time - 0.5) * (time - 0.5))
    , step(time, 0.5))
    //)
    ;
}

vec3 spiral(vec2 uv, float time) {
    float logr = (uv.x * uv.x + uv.y * uv.y < 0.1) ? 0.0 : log(length(uv));
    float theta = (uv.y == 0.0 && uv.x == 0.0) ? 0.0 : atan(uv.y, uv.x);
    return color(
        zigzag(2.0 * (
            1.0 * logr + 6. * theta / TAU
        )) * 0.4 + sway(time) * 0.5
    );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.0 * fragCoord - iResolution.xy) / length(iResolution.xy);
    float time = fract(iTime / 8.0);
    vec2 uv_kal = kaleido(uv, time * TAU, 3.0 * time * TAU / REP);
    float scale = 6.0 + sway(time) * 24.0;
    vec3 colSpiral = spiral(
        (round(uv_kal * scale)) / 8., time
    );
    float lines = step(0.97 - scale * 0.003, max(zigzag(2. * scale * uv_kal.x), zigzag(2. * scale * uv_kal.y)));

    fragColor = vec4(mix(colSpiral, color(sway(time+0.5) * 0.9), lines), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

